<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'nominate_topic');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array('nominate_topic_stamps', 'nominate_topic_box', 'nominate_topic_box_bit', 'nominate_topic_button', 'nominate_topic_postbit', 'nominate_topic_postbit_legacy', 'nominate_topic_awards_winners');

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_nominate_topic.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$vbulletin->input->clean_array_gpc('r', array('using_ajax' => TYPE_UINT,'securitytoken' => TYPE_STR));
$using_ajax = $vbulletin->GPC['using_ajax'];
$securitytoken = $vbulletin->GPC['securitytoken'];

($hook = vBulletinHook::fetch_hook('nominate_topic_main_start')) ? eval($hook) : false;

if ($_REQUEST['do'] == 'shownominationawardswinners'){

	global $vbulletin, $vbphrase;
	require_once(DIR . '/includes/functions_user.php');

	$topx_limit = 10;

	$get_most_awarded = $vbulletin->db->query_read("SELECT userid, username, usertitle, nominate_topic_user_amount, nominate_topic_nominated_posts, nominate_topic_nominated_times, nominate_topic_nominated_awards FROM " . TABLE_PREFIX . "user WHERE nominate_topic_nominated_awards > 0 ORDER BY nominate_topic_nominated_awards DESC LIMIT 0,".$topx_limit);
	$nb_most_awarded = $vbulletin->db->num_rows($get_most_awarded);

	$halloffame = "";

	$perc_column = "20%";

	$i = 0;
	if ($nb_most_awarded != 0){
		while ($row = $vbulletin->db->fetch_array($get_most_awarded)){
			$i++;
			$user_id = $row['userid'];
			$user_name = $row['username'];
			$user_title = $row['usertitle'];

			$arravatarurl = fetch_avatar_url($row['userid']);
			$avatarurl = $arravatarurl[0];
			if (strlen($avatarurl)<3) $avatarurl = $mwatestme.'images/nominate/nobody_m.gif';

			$user_amount = $row['nominate_topic_user_amount'];
			$user_nominated_posts = $row['nominate_topic_nominated_posts'];
			$user_nominated_times = $row['nominate_topic_nominated_times'];
			$user_nominated_awards = $row['nominate_topic_nominated_awards'];

			$user_amount_formatted = vb_number_format($user_amount);
			$user_nominated_posts_formatted = vb_number_format($user_nominated_posts);
			$user_nominated_times_formatted = vb_number_format($user_nominated_times);
			$user_nominated_awards_formatted = vb_number_format($user_nominated_awards);
			$user_nominated_awards_phrase = construct_phrase($vbphrase[nominate_topic_nominated_awards_TOTWFM], $user_nominated_awards_formatted);

			if ($user_nominated_times == 1){
				$useruser_nominated_times_phrase = $vbphrase[nominate_topic_time_post];
			}
			else {
				if ($user_nominated_posts == 1){
					$useruser_nominated_times_phrase = construct_phrase($vbphrase[nominate_topic_times_post], $user_nominated_times_formatted);
				}
				else {
					$useruser_nominated_times_phrase = construct_phrase($vbphrase[nominate_topic_times_post], $user_nominated_times_formatted, $user_nominated_posts_formatted);
				}
			}

			$user_search_user = construct_phrase($vbphrase[nominate_topic_search_user], $user_name);
			$user_search_user_made = construct_phrase($vbphrase[nominate_topic_search_user_made], $user_name);


			$current_nominees = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE userid='$user_id'");
			$nb_current_nominees = $vbulletin->db->num_rows($current_nominees);


			$table_column[$i-1] = "<td class=\"panelsurround\" align=\"center\" width=\"" . $perc_column . "\">
				<div class=\"panel\">
					<div align=\"" . $stylevar[left] . "\">
						<fieldset class=\"fieldset\">						
							<legend>			
								<img src=\"" . $mwatestme . "images/nominate/award_star_gold_3.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" border=\"0\" />
							</legend>
							<div style=\"padding:" . $stylevar[formspacer] . "px\">
								<div class=\"fieldset\" align=\"center\">
									<a href=\"member.php?" . $session[sessionurl] . "u=" . $user_id . "\">
										<img src=\"" . $avatarurl . "\" height=\"100\" alt=\"" . $user_username . " ". $vbphrase[xs_avatar] . "\" border=\"0\" />
									</a><br />
									<a class=\"bigusername\" href=\"member.php?" . $session[sessionurl] . "u=" . $user_id . "\">" . $user_name . "</a>
									<div><strong>" . $user_title . "</strong></div>
									<br />
									<fieldset class=\"statistics_group\">
										<legend>" . $vbphrase[nominate_topic_nominations_statistics] . "</legend>" .
										$vbphrase[nominate_topic_total_nominations] . $user_nominated_posts_formatted . "<br />" .
										$vbphrase[nominate_topic_current_nominees] . $nb_current_nominees . "<br />" .
										$useruser_nominated_times_phrase . "<br />
										<span class=\"shade\"><img src=\"" . $mwatestme . "images/nominate/award_star_gold_3.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $user_nominated_awards_phrase . "</span><br />";

										if ($user_nominated_posts > 0){
											$table_column[$i-1] = $table_column[$i-1] . "<a href=\"nominate_topic.php?" . $session[sessionurl] . "do=findnominations&amp;u=" . $user_id . "\">" . $user_search_user . "</a><br />";
										}

										if ($vbulletin->options[nominate_topic_display_username]){
											if ($nb_current_nominees > 0){
												$table_column[$i-1] = $table_column[$i-1] . "  . <a href=\"nominate_topic.php?" . $session[sessionurl] . "do=findnominations_user_made&amp;u=" . $user_id . "\">" . $user_search_user_made . "</a><br />";
											}
										}
		$table_column[$i-1] = $table_column[$i-1] . "</fieldset>
								</div>
							</div>
						</fieldset>
					</div>
				</div>
				<div align=\"center\" style=\"margin-top:$stylevar[cellpadding]px\">&nbsp;</div>
			</td>";
		}
	
		switch ($i) {
			case 1:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . "</tr></table> &nbsp;<br />";
				break;
			case 2:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"2\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . "</tr></table> &nbsp;<br />";
				break;
			case 3:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"3\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr></table> &nbsp;<br />";
				break;
			case 4:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"4\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 5: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 6: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr></table> &nbsp;<br />";
				break;
			case 7: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 8: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 9: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr></table> &nbsp;<br />";
				break;
			case 10: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_members] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr><tr>" . $table_column[9] . "<td colspan=\"2\">&nbsp;</td>"  . "</tr></table> &nbsp;<br />";
				break;
		}
	}

	$halloffame_people = $halloffame;

	// get thread info
	$get_most_awarded = $vbulletin->db->query_read("SELECT threadid, postid, title, userid, username, nominate_topic_amount, nominate_topic_award, nominate_topic_award_rank FROM " . TABLE_PREFIX . "post WHERE nominate_topic_award > 0 ORDER BY nominate_topic_amount DESC LIMIT 0,".$topx_limit);
	$nb_most_awarded = $vbulletin->db->num_rows($get_most_awarded);

	$halloffame = "";

	$i = 0;
	if ($nb_most_awarded != 0){
		while ($row = $vbulletin->db->fetch_array($get_most_awarded)){
			$i++;

			$topic_threadid = $row['threadid'];
			$topic_postid = $row['postid'];
			$topic_title = $row['title'];
			$topic_userid = $row['userid'];
			$topic_username = $row['username'];

			$topic_amount = $row['nominate_topic_amount'];
			$awarddate = $row['nominate_topic_award'];
			$topic_award = $vbphrase[nominate_topic_submitted] . $topic_amount . $vbphrase[nominate_topic_for_nomination_on] . strftime("%A %d, %B, %Y", $awarddate);
			$topic_award_rank = $row['nominate_topic_award_rank'];

			$table_column[$i-1] = "<td class=\"panelsurround\" align=\"center\" width=\"" . $perc_column . "\">
				<div class=\"panel\">
					<div align=\"" . $stylevar[left] . "\">
						<fieldset class=\"fieldset\">						
							<legend>			
								<img src=\"" . $mwatestme . "images/nominate/page_white_medal.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" border=\"0\" />
							</legend>
							<div style=\"padding:" . $stylevar[formspacer] . "px\">
								<div class=\"fieldset\" align=\"center\">
									<img src=\"" . $mwatestme . "images/nominate/awards_ribbon.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" align=\"left\" border=\"0\" />
									<a class=\"bigusername\" href=\"showthread.php?" . $session[sessionurl] ."t=". $topic_threadid . "&p=" . $topic_postid . "\">" . $topic_title . "</a>
									<div><strong>$vbphrase[nominate_topic_owner]</strong>&nbsp;<a href=\"member.php?". $session[sessionurl] . "u=". $topic_userid . "\">" . $topic_username . "</a></div>
									<br />" . $topic_award . "
								</div>
							</div>
						</fieldset>
					</div>
				</div>
				<div align=\"center\" style=\"margin-top:$stylevar[cellpadding]px\">&nbsp;</div>
			</td>";
		}

		switch ($i) {
			case 1:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . "</tr></table> &nbsp;<br />";
				break;
			case 2:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"2\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . "</tr></table> &nbsp;<br />";
				break;
			case 3:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"3\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr></table> &nbsp;<br />";
				break;
			case 4:
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"4\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 5: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 6: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr></table> &nbsp;<br />";
				break;
			case 7: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 8: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
				break;
			case 9: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr></table> &nbsp;<br />";
				break;
			case 10: 
				$halloffame = "
					<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
						<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_topics] . "</td></tr>
						<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr><tr>" . $table_column[9] . "<td colspan=\"2\">&nbsp;</td>"  . "</tr></table> &nbsp;<br />";
				break;
		}
	}

	$halloffame_posts = $halloffame;

	$halloffame_blog = "";

	// get blog info if any
	if ($vbulletin->options['nominate_topic_blog_on_off']){

		$get_most_awarded = $vbulletin->db->query_read("SELECT blogid, title, userid, username, nominate_topic_amount, nominate_topic_award, nominate_topic_award_rank FROM " . TABLE_PREFIX . "blog WHERE nominate_topic_award > 0 ORDER BY nominate_topic_amount DESC LIMIT 0,".$topx_limit);
		$nb_most_awarded = $vbulletin->db->num_rows($get_most_awarded);

		$halloffame = "";

		$i = 0;
		if ($nb_most_awarded != 0){
			while ($row = $vbulletin->db->fetch_array($get_most_awarded)){
				$i++;

				$topic_blogid = $row['blogid'];
				$topic_title = $row['title'];
				$topic_userid = $row['userid'];
				$topic_username = $row['username'];

				$topic_amount = $row['nominate_topic_amount'];
				$awarddate = $row['nominate_topic_award'];
				$topic_award = $vbphrase[nominate_topic_submitted] . $topic_amount . $vbphrase[nominate_topic_for_nomination_on] . strftime("%A %d, %B, %Y", $awarddate);
				$topic_award_rank = $row['nominate_topic_award_rank'];

				$table_column[$i-1] = "<td class=\"panelsurround\" align=\"center\" width=\"" . $perc_column . "\">
					<div class=\"panel\">
						<div align=\"" . $stylevar[left] . "\">
							<fieldset class=\"fieldset\">						
								<legend>			
									<img src=\"" . $mwatestme . "images/nominate/page_white_medal.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" border=\"0\" />
								</legend>
								<div style=\"padding:" . $stylevar[formspacer] . "px\">
									<div class=\"fieldset\" align=\"center\">
										<img src=\"" . $mwatestme . "images/nominate/awards_ribbon.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" align=\"left\" border=\"0\" />
										<a class=\"bigusername\" href=\"blog.php?" . $session[sessionurl] ."b=". $topic_blogid . "\">" . $topic_title . "</a>
										<div><strong>$vbphrase[nominate_topic_owner]</strong>&nbsp;<a href=\"member.php?". $session[sessionurl] . "u=". $topic_userid . "\">" . $topic_username . "</a></div>
										<br />" . $topic_award . "
									</div>
								</div>
							</fieldset>
						</div>
					</div>
					<div align=\"center\" style=\"margin-top:$stylevar[cellpadding]px\">&nbsp;</div>
				</td>";
			}

			switch ($i) {
				case 1:
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . "</tr></table> &nbsp;<br />";
					break;
				case 2:
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"2\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . "</tr></table> &nbsp;<br />";
					break;
				case 3:
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"3\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr></table> &nbsp;<br />";
					break;
				case 4:
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"4\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
					break;
				case 5: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
					break;
				case 6: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr></table> &nbsp;<br />";
					break;
				case 7: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . "<td colspan=\"2\">&nbsp;</td>" . "</tr></table> &nbsp;<br />";
					break;
				case 8: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . "<td>&nbsp;</td>" . "</tr></table> &nbsp;<br />";
					break;
				case 9: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr></table> &nbsp;<br />";
					break;
				case 10: 
					$halloffame = "
						<table class=\"tborder\" cellpadding=\"" . $stylevar[cellpadding] . "\" cellspacing=\"" . $stylevar[cellspacing] . "\" border=\"0\" width=\"100%\" align=\"center\">
							<tr><td class=\"tcat\" colspan=\"5\"><img src=\"" . $mwatestme . "images/nominate/award_winner.gif\" alt=\"" . $vbphrase[nominated_topic_nominations] . "\" style=\"vertical-align:middle\" border=\"0\" />&nbsp;" . $vbphrase[nominate_topic_halloffame_blogs] . "</td></tr>
							<tr>" . $halloffame . $table_column[0] . $table_column[1] . $table_column[2] . "</tr><tr>" . $table_column[3] . $table_column[4] . $table_column[5] . "</tr><tr>" . $table_column[6] . $table_column[7] . $table_column[8] . "</tr><tr>" . $table_column[9] . "<td colspan=\"2\">&nbsp;</td>"  . "</tr></table> &nbsp;<br />";
					break;
			}
		}

		$halloffame_blog = $halloffame;
	}

	$halloffame_top_ten = $halloffame_people . $halloffame_posts . $halloffame_blog;

	if (empty($halloffame_top_ten)){
		$halloffame_top_ten = $vbphrase['nominate_topic_empty_hall_of_fame'];
	}

	$navbits = array();
	$navbits[$parent] = $vbphrase[nominate_topic_halloffame_title];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('print_output("' . fetch_template('nominate_topic_awards_winners') . '");');

}

if ($_REQUEST['do'] == 'shownominationthread'){

	$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
	$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);
	if ($nb_rows != 0){
		$nt_thread = $vbulletin->db->fetch_array($nominatetopicthread);
		$vbulletin->url = 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . "t=".$nt_thread[threadid] . "&p=".$nt_thread[postid];
		eval(print_standard_redirect(' ', true));
	}
	else {
		eval(standard_error(fetch_error('nominate_topic_nomination_thread_missing')));
	}
}

if ($_REQUEST['do'] == 'nominate_topic_add'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_main_add_nomination_start')) ? eval($hook) : false;

	$ispost = $vbulletin->input->clean_gpc('r', 'p', TYPE_UINT);

	if ($ispost != 0){
		$postinfo = array_merge($postinfo, fetch_userinfo($postinfo['userid']));

		if (nominate_topic_off($forumid, $postinfo, $bloginfo, $threadinfo['firstpostid'], '') || !can_nominate_this_post($postinfo, $bloginfo, $threadinfo['isdeleted'], true, '', $securitytoken) || nominated_already($postinfo, $bloginfo, '')){
			$using_ajax ? exit : print_no_permission();
		}

		add_nomination($postinfo, '', true);
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$blogid = $vbulletin->input->clean_gpc('r', 'b', TYPE_UINT);

			require_once(DIR . '/includes/blog_functions.php');
			$bloginfo = fetch_bloginfo($blogid);
			$bloginfo = array_merge($bloginfo, fetch_userinfo($bloginfo['userid']));

			if (nominate_topic_off('', $postinfo, $bloginfo, '', 'blog') || !can_nominate_this_post($postinfo, $bloginfo, '', true, 'blog', $securitytoken) || nominated_already($postinfo, $bloginfo, 'blog')){
				$using_ajax ? exit : print_no_permission();
			}

			add_nomination($postinfo, $bloginfo, false);
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_main_add_nomination_end')) ? eval($hook) : false;

	if ($ispost != 0){
		if ($using_ajax){
			$nominations = fetch_nominations($postid, '', true, '');

			$postinfo['nominate_topic_bit'] = fetch_nominations_bit($forumid, $nominations, '');
		
			$postinfo['nominate_topic_amount'] = $postinfo['nominate_topic_amount'] + 1;
			$postinfo['nominate_topic_amount_formatted'] = vb_number_format($postinfo['nominate_topic_amount']);

			if ($vbulletin->options['nominate_topic_delete_own'])
			{
				$postinfo['show_nominations_remove_option'] = true;
			}

			if (($vbulletin->userinfo['usergroupid'] == 6) || (in_array($vbulletin->userinfo['usergroupid'], explode(",", $vbulletin->options['nominate_topic_delete_allowed_usergroups'])))){
				$postinfo['nominate_topic_candelete_all'] = 1;
			}

			$echo = fetch_nominate_topic_template($postinfo, '', '');
			echo "$echo";
			exit;
		}
		else{
			$vbulletin->url = "showthread.php?$session[sessionurl]p=$postid";
			eval(print_standard_redirect('redirect_nominate_topic'));
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			if ($using_ajax){
				$nominations = fetch_nominations($blogid, '', true, 'blog');

				$bloginfo['nominate_topic_bit'] = fetch_nominations_bit('', $nominations, 'blog');

				$bloginfo['nominate_topic_amount'] = $bloginfo['nominate_topic_amount'] + 1;
				$bloginfo['nominate_topic_amount_formatted'] = vb_number_format($bloginfo['nominate_topic_amount']);

				if ($vbulletin->options['nominate_topic_delete_own'])
				{
					$bloginfo['show_nominations_remove_option'] = true;
				}

				if (($vbulletin->userinfo['usergroupid'] == 6) || (in_array($vbulletin->userinfo['usergroupid'], explode(",", $vbulletin->options['nominate_topic_delete_allowed_usergroups'])))){
					$bloginfo['nominate_topic_candelete_all'] = 1;
				}

				$echo = fetch_nominate_topic_template($bloginfo, $bloginfo, 'blog');
				echo "$echo";
				exit;
			}
			else{
				$vbulletin->url = "blog.php?$session[sessionurl]b=$blogid";
				eval(print_standard_redirect('redirect_nominate_topic'));
			}
		}
	}
}


if ($_REQUEST['do'] == 'nominate_topic_remove_all'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_all_nominations_start')) ? eval($hook) : false;

	$ispost = $vbulletin->input->clean_gpc('r', 'p', TYPE_UINT);

	if (($ispost == 0) && ($vbulletin->options['nominate_topic_blog_on_off'])){
		$blogid = $vbulletin->input->clean_gpc('r', 'b', TYPE_UINT);

		require_once(DIR . '/includes/blog_functions.php');
		$bloginfo = fetch_bloginfo($blogid);
		$bloginfo = array_merge($bloginfo, fetch_userinfo($bloginfo['userid']));
	}


	if (!(can_delete_all_nominations())){
		$using_ajax ? exit : print_no_permission();
	}

	delete_all_nominations($postinfo, $bloginfo, $ispost);

	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_all_nominations_end')) ? eval($hook) : false;

	if ($using_ajax){
		exit;
	}
	else{
		if ($ispost != 0){
			$vbulletin->url = "showthread.php?$session[sessionurl]p=$postid";
			eval(print_standard_redirect('redirect_nominate_topic'));
		}
		else {
			if ($vbulletin->options['nominate_topic_blog_on_off']){
				$vbulletin->url = "blog.php?$session[sessionurl]b=$blogid";
				eval(print_standard_redirect('redirect_nominate_topic'));
			}
		}
	}
}

if ($_REQUEST['do'] == 'nominate_topic_remove_user'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_nominations_start')) ? eval($hook) : false;

	$ispost = $vbulletin->input->clean_gpc('r', 'p', TYPE_UINT);

	if ($ispost != 0){
		if (!(delete_nomination($postinfo, '', $ispost, $vbulletin->userinfo['userid']))){
			$using_ajax ? exit : print_no_permission();
		}	
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$blogid = $vbulletin->input->clean_gpc('r', 'b', TYPE_UINT);

			require_once(DIR . '/includes/blog_functions.php');
			$bloginfo = fetch_bloginfo($blogid);
			$bloginfo = array_merge($bloginfo, fetch_userinfo($bloginfo['userid']));

			if (!(delete_nomination('', $bloginfo, $ispost, $vbulletin->userinfo['userid']))){
				$using_ajax ? exit : print_no_permission();
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_nominations_end')) ? eval($hook) : false;

	if ($ispost != 0){
		$postinfo['nominate_topic_amount'] = $postinfo['nominate_topic_amount'] - 1;

		if ($postinfo['nominate_topic_amount'] > 0 && $using_ajax){
			$nominations = fetch_nominations($postid, '', true, '');

			$postinfo['nominate_topic_bit'] = fetch_nominations_bit($forumid, $nominations, '');
	
			$postinfo['nominate_topic_amount_formatted'] = vb_number_format($postinfo['nominate_topic_amount']);
			$postinfo['nominate_topic_user'] = false;
			$postinfo['ajax'] = true;

			if (($vbulletin->userinfo['usergroupid'] == 6) || (in_array($vbulletin->userinfo['usergroupid'], explode(",", $vbulletin->options['nominate_topic_delete_allowed_usergroups'])))){
				$postinfo['nominate_topic_candelete_all'] = 1;
			}

			$echo = fetch_nominate_topic_template($postinfo, '', '');
			echo "$echo";
			exit;
		}
		else if ($using_ajax){
			exit;
		}
		else{
			$vbulletin->url = "showthread.php?$session[sessionurl]p=$postid";
			eval(print_standard_redirect('redirect_nominate_topic'));
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$bloginfo['nominate_topic_amount'] = $bloginfo['nominate_topic_amount'] - 1;

			if ($bloginfo['nominate_topic_amount'] > 0 && $using_ajax){
				$nominations = fetch_nominations($blogid, '', true, 'blog');

				$bloginfo['nominate_topic_bit'] = fetch_nominations_bit('', $nominations, 'blog');
	
				$bloginfo['nominate_topic_amount_formatted'] = vb_number_format($bloginfo['nominate_topic_amount']);
				$bloginfo['nominate_topic_user'] = false;
				$bloginfo['ajax'] = true;

				if (($vbulletin->userinfo['usergroupid'] == 6) || (in_array($vbulletin->userinfo['usergroupid'], explode(",", $vbulletin->options['nominate_topic_delete_allowed_usergroups'])))){
					$bloginfo['nominate_topic_candelete_all'] = 1;
				}

				$echo = fetch_nominate_topic_template($bloginfo, $bloginfo, 'blog');
				echo "$echo";
				exit;
			}
			else if ($using_ajax){
				exit;
			}
			else{
				$vbulletin->url = "blog.php?$session[sessionurl]b=$blogid";
				eval(print_standard_redirect('redirect_nominate_topic'));
			}
		}
	}
}

if ($_REQUEST['do'] == 'nominate_topic_remove_all_from_user'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_all_nominees_start')) ? eval($hook) : false;

	$user_id = $vbulletin->input->clean_gpc('r', 'u', TYPE_UINT);
	$post_id_redirect = $vbulletin->input->clean_gpc('r', 'p', TYPE_UINT);

	$nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE userid='$user_id' ORDER BY username");
	$nb=$vbulletin->db->num_rows($nominations);

	if ($nb != 0){
		while ($row = $vbulletin->db->fetch_array($nominations)){

			$isblog = $row['is_blog'];
			$post_id = $row['postid'];

			if (!($isblog)){
				$get_post = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE postid = '$post_id'");
				$nb_rows = $vbulletin->db->num_rows($get_post);
				if ($nb_rows != 0) {
					$postinfo = $vbulletin->db->fetch_array($get_post);
					delete_nomination($postinfo, '', true, $user_id);
				}
			}
			else {
				$get_post = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE blogid = '$post_id'");
				$nb_rows = $vbulletin->db->num_rows($get_post);
				if ($nb_rows != 0) {
					$bloginfo = $vbulletin->db->fetch_array($get_post);
					delete_nomination('', $bloginfo, false, $user_id);
				}
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_all_nominees_end')) ? eval($hook) : false;

	if (($nb != 0) && $using_ajax){
		echo " ";
		$vbulletin->url = "showthread.php?$session[sessionurl]p=$post_id_redirect";
		eval(print_standard_redirect('redirect_nominate_topic_success', true)); 	
	}
	else if ($using_ajax){
		exit;
	}
	else{
		$vbulletin->url = "showthread.php?$session[sessionurl]p=$post_id_redirect";
		eval(print_standard_redirect('redirect_nominate_topic'));
	}
}

if ($_REQUEST['do'] == 'nominate_topic_remove_all_to_user'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_all_nominations_start')) ? eval($hook) : false;

	$user_id = $vbulletin->input->clean_gpc('r', 'u', TYPE_UINT);
	$post_id_redirect = $vbulletin->input->clean_gpc('r', 'p', TYPE_UINT);

	$nominatedposts = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE userid='$user_id' AND nominate_topic_amount > '0' AND nominate_topic_award = '0' ORDER BY postid");
	$nb = $vbulletin->db->num_rows($nominatedposts);

	if ($nb != 0){
		while ($row = $vbulletin->db->fetch_array($nominatedposts)){

			$post_id = $row['postid'];

			$get_nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$post_id' AND is_blog = '0'");
			$nb_rows = $vbulletin->db->num_rows($get_nominations);
			if ($nb_rows != 0) {

				$postinfo = fetch_postinfo($post_id);
				$postinfo = array_merge($postinfo, fetch_userinfo($postinfo['userid']));

				while ($row_nomination = $vbulletin->db->fetch_array($get_nominations)){
					$post_userid = $row_nomination['userid'];

					delete_nomination($postinfo, '', true, $post_userid);
				}
			}
		}
	}

	if ($vbulletin->options['nominate_topic_blog_on_off']){
		$nominatedposts = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE userid='$user_id' AND nominate_topic_amount > '0' AND nominate_topic_award = '0' ORDER BY blogid");
		$nb = $vbulletin->db->num_rows($nominatedposts);

		if ($nb != 0){
			while ($row = $vbulletin->db->fetch_array($nominatedposts)){

				$post_id = $row['postid'];

				$get_nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$post_id' AND is_blog = '1'");
				$nb_rows = $vbulletin->db->num_rows($get_nominations);
				if ($nb_rows != 0) {

					$bloginfo = fetch_bloginfo($post_id);
					$bloginfo = array_merge($bloginfo, fetch_userinfo($bloginfo['userid']));

					while ($row_nomination = $vbulletin->db->fetch_array($get_nominations)){
						$post_userid = $row_nomination['userid'];

						delete_nomination('', $bloginfo, false, $post_userid);
					}
				}
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_main_remove_user_all_nominations_end')) ? eval($hook) : false;

	if (($nb != 0) && $using_ajax){
		echo " ";
		$vbulletin->url = "showthread.php?$session[sessionurl]p=$post_id_redirect";
		eval(print_standard_redirect('redirect_nominate_topic_success', true)); 	
	}
	else if ($using_ajax){
		exit;
	}
	else{
		$vbulletin->url = "showthread.php?$session[sessionurl]p=$post_id_redirect";
		eval(print_standard_redirect('redirect_nominate_topic'));
	}
}

if ($_REQUEST['do'] == 'findnominations'){
	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	$vbulletin->input->clean_array_gpc('r', array('userid'	=> TYPE_UINT,));

	// valid user id?
	if (!$vbulletin->GPC['userid']){
		eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
	}

	// get user info
	if ($user = $db->query_first("SELECT userid, username, posts FROM " . TABLE_PREFIX . "user WHERE userid = " . $vbulletin->GPC['userid'])){
		$searchuser =& $user['username'];
	}
	// could not find specified user
	else{
		eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
	}

	// build search hash
	$query = '';
	$searchuser = $user['username'];
	$exactname = 1;
	$starteronly = 0;
	$forumchoice = $foruminfo['forumid'];
	$childforums = 1;
	$titleonly = 0;
	$showposts = 1;
	$searchdate = 0;
	$beforeafter = 'after';
	$replyless = 0;
	$replylimit = 0;
	$searchthreadid = 0;

	$searchhash = md5(TIMENOW . "||" . $vbulletin->userinfo['userid'] . "||" . strtolower($searchuser) . "||$exactname||$starteronly||$forumchoice||$childforums||$titleonly||$showposts||$searchdate||$beforeafter||$replyless||$replylimit||$searchthreadid");

	// start search timer
	$searchtime = microtime();

	$forumids = array();
	$noforumids = array();

	// check to see if we should be searching in a particular forum or forums
	if ($forumids = fetch_search_forumids($vbulletin->GPC['forumchoice'], $vbulletin->GPC['childforums'])){
		$showforums = true;
	}
	else {
		foreach ($vbulletin->forumcache AS $forumid => $forum){
			$fperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
			if (($fperms & $vbulletin->bf_ugp_forumpermissions['canview'])){
				$forumids[] = $forumid;
			}
		}
		$showforums = false;
	}

	if (empty($forumids)){
		eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
	}
	else{
		// query post ids in dateline DESC order...
		$orderedids = array();
		$posts = $db->query_read("
			SELECT postid
			FROM " . TABLE_PREFIX . "post AS post
			INNER JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
			WHERE post.userid = $user[userid]
				AND post.nominate_topic_amount != 0
				AND thread.forumid IN(" . implode(',', $forumids) . ")
			ORDER BY post.dateline DESC
			LIMIT " . ($vbulletin->options['maxresults'] * 2) . "
		");

		while ($post = $db->fetch_array($posts)){
			$orderedids[] = $post['postid'];
		}
		unset($post);
		$db->free_result($posts);

		// did we get some results?
		if (empty($orderedids)){
			eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
		}

		// set display terms
		$display = array(
			'words' => array(),
			'highlight' => array(),
			'common' => array(),
			'users' => array($user['userid'] => $user['username']),
			'forums' => iif($showforums, $display['forums'], 0),
			'options' => array(
				'starteronly' => 0,
				'childforums' => 1,
				'action' => 'process'
			)
		);

		// end search timer
		$searchtime = number_format(fetch_microtime_difference($searchtime), 5, '.', '');

		/*insert query*/
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "search (userid, ipaddress, personal, searchuser, forumchoice, sortby, sortorder, searchtime, showposts, orderedids, dateline, displayterms, searchhash)
			VALUES (" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', 1, '" . $db->escape_string($user['username']) . "', '" . $db->escape_string($forumchoice) . "', 'post.dateline', 'DESC', $searchtime, 1, '" . $db->escape_string(implode(',', $orderedids)) . "', " . TIMENOW . ", '" . $db->escape_string(serialize($display)) . "', '" . $db->escape_string($searchhash) . "')
		");
		$searchid = $db->insert_id();

		$vbulletin->url = 'search.php?' . $vbulletin->session->vars['sessionurl'] . "searchid=$searchid";
		eval(print_standard_redirect('search'));
	}
}

if ($_REQUEST['do'] == 'findnominations_user_made'){
	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	$vbulletin->input->clean_array_gpc('r', array(
		'userid'	=> TYPE_UINT,
	));

	// valid user id?
	if (!$vbulletin->GPC['userid']){
		eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
	}

	// get user info
	if ($user = $db->query_first("SELECT userid, username, posts FROM " . TABLE_PREFIX . "user WHERE userid = " . $vbulletin->GPC['userid'])){
		$searchuser =& $user['username'];
	}
	// could not find specified user
	else{
		eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
	}

	// build search hash
	$query = '';
	$searchuser = $user['username'];
	$exactname = 1;
	$starteronly = 0;
	$forumchoice = $foruminfo['forumid'];
	$childforums = 1;
	$titleonly = 0;
	$showposts = 1;
	$searchdate = 0;
	$beforeafter = 'after';
	$replyless = 0;
	$replylimit = 0;
	$searchthreadid = 0;

	$searchhash = md5(TIMENOW . "||" . $vbulletin->userinfo['userid'] . "||" . strtolower($searchuser) . "||$exactname||$starteronly||$forumchoice||$childforums||$titleonly||$showposts||$searchdate||$beforeafter||$replyless||$replylimit||$searchthreadid");

	// start search timer
	$searchtime = microtime();

	$forumids = array();
	$noforumids = array();

	// check to see if we should be searching in a particular forum or forums
	if ($forumids = fetch_search_forumids($vbulletin->GPC['forumchoice'], $vbulletin->GPC['childforums'])){
		$showforums = true;
	}
	else{
		foreach ($vbulletin->forumcache AS $forumid => $forum){
			$fperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
			if (($fperms & $vbulletin->bf_ugp_forumpermissions['canview'])){
				$forumids[] = $forumid;
			}
		}
		$showforums = false;
	}

	if (empty($forumids)){
		eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
	}
	else{
		// query post ids in dateline DESC order...
		$orderedids = array();
		$posts = $db->query_read("
			SELECT nominate_topic.postid AS postid
			FROM " . TABLE_PREFIX . "nominate_topic AS nominate_topic
			LEFT JOIN " . TABLE_PREFIX . "post AS post USING (postid)
			INNER JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
			WHERE nominate_topic.userid = $user[userid]
				AND thread.forumid IN(" . implode(',', $forumids) . ")
			ORDER BY post.dateline DESC
			LIMIT " . ($vbulletin->options['maxresults'] * 2) . "
		");

		while ($post = $db->fetch_array($posts)){
			$orderedids[] = $post['postid'];
		}
		unset($post);
		$db->free_result($posts);

		// did we get some results?
		if (empty($orderedids)){
			eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
		}

		// set display terms
		$display = array(
			'words' => array(),
			'highlight' => array(),
			'common' => array(),
			'users' => array($user['userid'] => $user['username']),
			'forums' => iif($showforums, $display['forums'], 0),
			'options' => array(
				'starteronly' => 0,
				'childforums' => 1,
				'action' => 'process'
			)
		);

		// end search timer
		$searchtime = number_format(fetch_microtime_difference($searchtime), 5, '.', '');

		/*insert query*/
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "search (userid, ipaddress, personal, searchuser, forumchoice, sortby, sortorder, searchtime, showposts, orderedids, dateline, displayterms, searchhash)
			VALUES (" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', 1, '" . $db->escape_string($user['username']) . "', '" . $db->escape_string($forumchoice) . "', 'post.dateline', 'DESC', $searchtime, 1, '" . $db->escape_string(implode(',', $orderedids)) . "', " . TIMENOW . ", '" . $db->escape_string(serialize($display)) . "', '" . $db->escape_string($searchhash) . "')
		");
		$searchid = $db->insert_id();

		$vbulletin->url = 'search.php?' . $vbulletin->session->vars['sessionurl'] . "searchid=$searchid";
		eval(print_standard_redirect('search'));
	}
}

if ($_REQUEST['do'] == 'findallnominations'){
	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	// build search hash
	$query = '';
	$searchuser = $user['username'];
	$exactname = 1;
	$starteronly = 0;
	$forumchoice = $foruminfo['forumid'];
	$childforums = 1;
	$titleonly = 0;
	$showposts = 1;
	$searchdate = 0;
	$beforeafter = 'after';
	$replyless = 0;
	$replylimit = 0;
	$searchthreadid = 0;

	$searchhash = md5(TIMENOW . "||" . $vbulletin->userinfo['userid'] . "||" . strtolower($searchuser) . "||$exactname||$starteronly||$forumchoice||$childforums||$titleonly||$showposts||$searchdate||$beforeafter||$replyless||$replylimit||$searchthreadid");

	// start search timer
	$searchtime = microtime();

	$forumids = array();
	$noforumids = array();

	// check to see if we should be searching in a particular forum or forums
	if ($forumids = fetch_search_forumids($vbulletin->GPC['forumchoice'], $vbulletin->GPC['childforums'])){
		$showforums = true;
	}
	else{
		foreach ($vbulletin->forumcache AS $forumid => $forum){
			$fperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
			if (($fperms & $vbulletin->bf_ugp_forumpermissions['canview'])){
				$forumids[] = $forumid;
			}
		}
		$showforums = false;
	}

	if (empty($forumids)){
		eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
	}
	else{
		// query post ids in dateline DESC order...
		$orderedids = array();
		$posts = $db->query_read("
			SELECT postid
			FROM " . TABLE_PREFIX . "post AS post
			INNER JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
			WHERE post.nominate_topic_amount != 0
				AND thread.forumid IN(" . implode(',', $forumids) . ")
			ORDER BY post.dateline DESC
			LIMIT " . ($vbulletin->options['maxresults'] * 2) . "
		");

		while ($post = $db->fetch_array($posts)){
			$orderedids[] = $post['postid'];
		}
		unset($post);
		$db->free_result($posts);

		// did we get some results?
		if (empty($orderedids)){
			eval(standard_error(fetch_error('searchnoresults', $displayCommon), '', false));
		}

		// set display terms
		$display = array(
			'words' => array(),
			'highlight' => array(),
			'common' => array(),
			'users' => array($user['userid'] => $user['username']),
			'forums' => iif($showforums, $display['forums'], 0),
			'options' => array(
				'starteronly' => 0,
				'childforums' => 1,
				'action' => 'process'
			)
		);

		// end search timer
		$searchtime = number_format(fetch_microtime_difference($searchtime), 5, '.', '');

		/*insert query*/
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "search (userid, ipaddress, personal, searchuser, forumchoice, sortby, sortorder, searchtime, showposts, orderedids, dateline, displayterms, searchhash)
			VALUES (" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', 1, '" . $db->escape_string($user['username']) . "', '" . $db->escape_string($forumchoice) . "', 'post.dateline', 'DESC', $searchtime, 1, '" . $db->escape_string(implode(',', $orderedids)) . "', " . TIMENOW . ", '" . $db->escape_string(serialize($display)) . "', '" . $db->escape_string($searchhash) . "')
		");
		$searchid = $db->insert_id();

		$vbulletin->url = 'search.php?' . $vbulletin->session->vars['sessionurl'] . "searchid=$searchid";
		eval(print_standard_redirect('search'));
	}
}

($hook = vBulletinHook::fetch_hook('nominate_topic_main_end')) ? eval($hook) : false;
?>
